﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.QuerySvcService;
using BMS.VistaIntegration.Mdws2.Implementation.EIS;
using BMS.Utils;
using BMS.VistaIntegration.Mdws2.Entities;

namespace BMS.VistaIntegration.Mdws2.Implementation.WF
{
    public class CombinePatientAppointmentCommand
    {
        public string PatientIen { get; set; }
        public IEnumerable<string> ClinicIens { get; set; }
        public DateTime? StartDate { get; set; }
        public DateTime? EndDate { get; set; }
        public bool HasMore { get; private set; }
    

        public CombinePatientAppointmentCommand()
        {
            HasMore = true;
        }

        public IList<PatientAppointment> Execute(QuerySvcSoap client)
        {
            if (!HasMore) throw new InvalidOperationException();

            if (PatientIen != null)
            {
                HasMore = false;
                return GetPatApp(client, PatientIen, ClinicIens);
            }
            else
            {
                InitClinicIens(client);
                List<PatientAppointment> result = new List<PatientAppointment>();
                ClinicIens.ForEach(clinicIen=>OnClinic(result,client, clinicIen));
                HasMore = false;
                return result;
            }
        }

        private IList<PatientAppointment> GetPatApp(QuerySvcSoap client, string patientIen, IEnumerable<string> clinicIens)
        {
            SinglePatientAppointmentCommand command = new SinglePatientAppointmentCommand();
            command.ClinicIens = clinicIens;
            command.PatientIen = patientIen;
            command.StartDate = StartDate;
            command.EndDate = EndDate;
            IList<PatientAppointment> result = command.Execute(client);
            return result;
        }


        private void OnClinic(List<PatientAppointment> result,QuerySvcSoap client, string clinicIen)
        {
            ClinicPatientAppointmentCommand command = new ClinicPatientAppointmentCommand(clinicIen);
            command.StartDate = StartDate;
            command.EndDate = EndDate;
            var patientIens = command.Execute(client).Select(s => s.PatientIen).Distinct();
            
            foreach (var p in patientIens)
            {
                IList<PatientAppointment> patApp = GetPatApp(client, p, new string[] { clinicIen });
                result.AddRange(patApp);
            }
        }

        private string[] allClinicIens;

        private void InitClinicIens(QuerySvcSoap client)
        {
            if (ClinicIens != null) return;
            if (allClinicIens == null)
            {
                HospitalLocationCommand command = new HospitalLocationCommand();
                allClinicIens = command.Execute(client).Select(s => s.IEN).ToArray();
            }
            ClinicIens = allClinicIens;
        }
    }
}
